

# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# maximize the two variationally dependant pieces: p(Y | .) & p(M | .)
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

optimize_reparam <- function(dat, fmla, beta_start, func, px, opt){
 
 fmla_m = fmla$fmla_m
 fmla_l = fmla$fmla_l
 fmla_f = fmla$fmla_f
 
 # Prepare the data
 Xm = as.matrix(model.matrix(fmla_m, data=model.frame(dat, na.action = NULL)))
 Xl = as.matrix(model.matrix(fmla_l, data=model.frame(dat, na.action = NULL)))
 Xf = as.matrix(model.matrix(fmla_f, data=model.frame(dat, na.action = NULL)))
 
 # Initial values for beta
 if (length(beta_start) == 0){
  beta_start = rep(0.1, ncol(Xm) + ncol(Xl) + ncol(Xf) + 2) # added 1 for w_0 and w_a 
  names(beta_start) = c(colnames(Xm), colnames(Xl), colnames(Xf), "w0", "wa")
 }
 
 # Define the negative log likelihood function   
 eval_f <- function(beta, dat, Xm, Xl, Xf, func, px, opt){
  n = nrow(dat)
  p = length(beta)
  beta_m = beta[1:ncol(Xm)]
  beta_l = beta[(ncol(Xm)+1):(ncol(Xm)+ncol(Xl))]
  beta_f = beta[(ncol(Xm)+ncol(Xl)+1):(p-2)]
  w0 = beta[p-1]
  wa = beta[p]
  names(beta_m) = colnames(Xm)
  names(beta_l) = colnames(Xl)
  names(beta_f) = colnames(Xf)
  names(w0) = c("w0")
  names(wa) = c("wa")
  beta_y = c(beta_f, w0, wa)
  M = dat$M
  L = dat$L
  Y = dat$Y
  
  Y_hat = estimate_Y(dat, beta_y, beta_l, beta_m, px)
  p_Y = dnorm(Y, Y_hat, 1)
  
  p_L1 = 1/(1+exp(-Xl%*%beta_l))
  p_L = L*p_L1 + (1-L)*(1-p_L1)
  
  p_M1 = 1/(1+exp(-Xm%*%beta_m))
  p_M = M*p_M1 + (1-M)*(1-p_M1)
  
  f = sum(log(p_M) + log(p_L) + log(p_Y))
  
  return(-f/n)
 }
 
 # Define the inequlity constraint 
 eval_g_ineq <- function(beta, dat, Xm, Xl, Xf, func, px, opt){
  
  tau_u = opt$tau_u
  tau_l = opt$tau_l
  
  n = nrow(dat)
  p = length(beta)
  beta_m = beta[1:ncol(Xm)]
  beta_l = beta[(ncol(Xm)+1):(ncol(Xm)+ncol(Xl))]
  beta_f = beta[(ncol(Xm)+ncol(Xl)+1):(p-2)]
  w0 = beta[p-1]
  wa = beta[p]
  # names(beta_m) = colnames(Xm)
  # names(beta_l) = colnames(Xl)
  # names(beta_f) = colnames(Xf)
  # names(w0) = c("w0")
  # names(wa) = c("wa")
  # beta_y = c(beta_f, w0, wa)
  # 
  # beta_par = list(beta_y=beta_y, beta_l=beta_l, beta_m=beta_m, beta_a=NULL)
  # pse = func(dat, beta_par, px, opt)
  pse = wa
  
  eval_g =  c(pse - tau_u, tau_l - pse)
  return(eval_g)
 }
 
 # Solve the optimization problem
 mle_res = nloptr(x0=beta_start, 
                  eval_f=eval_f, 
                  eval_g_ineq=eval_g_ineq,
                  opts = list("algorithm"="NLOPT_LN_COBYLA","xtol_rel"=1.0e-8, "maxeval"=50000),
                  dat=dat, Xm=Xm, Xl=Xl, Xf=Xf, func=func, px=px, opt=opt)
 
 # Returnt the parameters
 beta = mle_res$solution
 p = length(beta)
 
 beta_m = beta[1:ncol(Xm)]
 beta_l = beta[(ncol(Xm)+1):(ncol(Xm)+ncol(Xl))]
 beta_f = beta[(ncol(Xm)+ncol(Xl)+1):(p-2)]
 w0 = beta[p-1]
 wa = beta[p]
 beta_y = c(beta_f, w0, wa)
 
 names(beta_m) = colnames(Xm)
 names(beta_l) = colnames(Xl)
 names(beta_y) = c(colnames(Xf), "w0", "wa")
 
 return(list(beta_m = beta_m, 
             beta_l = beta_l, 
             beta_y = beta_y))
}


